from matplotlib import pyplot as plt
import pandas as pd
import numpy as np
import csv 
from collections import Counter

plt.style.use("fivethirtyeight")

# use pandas to load data
data = pd.read_csv('data.csv')
# extract columns
ids = data['Responder_id']
lang_responses = data['LanguagesWorkedWith']

language_counter = Counter()
for response in lang_responses:
    language_counter.update(response.split(";"))
    
languages = []
popularity = []

for item in language_counter.most_common(15):
    languages.append(item[0])
    popularity.append(item[1])
    
languages.reverse()
popularity.reverse()
    
plt.figure(1)
plt.barh(languages, popularity)
plt.title("Most popular programming languages survey")
# swap labels for horizontal
plt.ylabel("Language")
plt.xlabel("Numer of users in the survey")

plt.tight_layout()

plt.savefig("pandas_horizontal_bar.png")

plt.show()

